<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:xs="http://www.w3.org/2001/XMLSchema" exclude-result-prefixes="xs" version="1.0">
    <xsl:output method="xml" indent="yes"/>

    <!-- copies all content which is not explicitly addressed by templates -->
    <xsl:template match="* | @* | processing-instruction() | comment()" name="default">
        <xsl:copy>
            <xsl:apply-templates select="node() | @* | processing-instruction() | comment()"/>
        </xsl:copy>
    </xsl:template>

    <!-- AppearanceAction now is choice instead of sequence, thus the second element is removed to make it a valid OSC 1.3 scenario -->
    <xsl:template match="//AppearanceAction">
        <xsl:element name="AppearanceAction">
            <xsl:choose>
                <xsl:when test="./LightStateAction and ./AnimationAction">
                    <xsl:message terminate="no"> WARNING: AppearanceAction cannot contain both
                        LightStateAction and AnimationAction since they exclude each other (choice).
                        The second element is automatically removed. Please check the output
                        manually to make sure the resulting scenario is correct. </xsl:message>
                    <xsl:call-template name="LightStateActionFromAppearanceAction"/>
                </xsl:when>
                <xsl:when test="./LightStateAction and not(./AnimationAction)">
                    <xsl:call-template name="LightStateActionFromAppearanceAction"/>
                </xsl:when>
                <xsl:when test="./AnimationAction and not(./LightStateAction)">
                    <xsl:call-template name="AnimationActionFromAppearanceAction"/>
                </xsl:when>
            </xsl:choose>
        </xsl:element>
    </xsl:template>
	
	<!-- LightStateAction now is choice instead of sequence, thus the second element is removed to make it a valid OSC 1.3 scenario -->
    <xsl:template name="LightStateActionFromAppearanceAction">
        <xsl:element name="LightStateAction">
            <xsl:copy-of select="./LightStateAction/@transitionTime"/>
            <xsl:call-template name="LightTypeFromAppearanceAction"/>
            <xsl:copy-of select="./LightStateAction/LightState"/>
        </xsl:element>
    </xsl:template>
	
	<!-- LightType now is choice instead of sequence, thus the second element is removed to make it a valid OSC 1.3 scenario -->
    <xsl:template name="LightTypeFromAppearanceAction">
        <xsl:element name="LightType">
            <xsl:choose>
                <xsl:when
                    test="./LightStateAction/LightType/VehicleLight and ./LightStateAction/LightType/UserDefinedLight">
                    <xsl:message terminate="no"> WARNING: LightType cannot contain both VehicleLight
                        and UserDefinedLight since they exclude each other. The second element is
                        automatically removed. Please check the output manually to make sure the
                        resulting scenario is correct. </xsl:message>
                    <xsl:copy-of select="./LightStateAction/LightType/VehicleLight"/>
                </xsl:when>
                <xsl:when
                    test="./LightStateAction/LightType/VehicleLight and not(./LightStateAction/LightType/UserDefinedLight)">
                    <xsl:copy-of select="./LightStateAction/LightType/VehicleLight"/>
                </xsl:when>
                <xsl:when
                    test="./LightStateAction/LightType/UserDefinedLight and not(./LightStateAction/LightType/VehicleLight)">
                    <xsl:copy-of select="./LightStateAction/LightType/UserDefinedLight"/>
                </xsl:when>
            </xsl:choose>
        </xsl:element>
    </xsl:template>
    <xsl:template name="AnimationActionFromAppearanceAction">
        <xsl:element name="AnimationType">
            <xsl:copy-of select="./AnimationAction/@animationDuration"/>
            <xsl:copy-of select="./AnimationAction/@loop"/>
            <xsl:call-template name="AnimationTypeFromAppearanceAction"/>
            <xsl:copy-of select="./AnimationAction/AnimationState"/>
        </xsl:element>
    </xsl:template>
    <xsl:template name="AnimationTypeFromAppearanceAction">
        <xsl:element name="AnimationType">
            <xsl:call-template name="ComponentAnimationFromAppearanceAction"/>
            <xsl:copy-of select="./AnimationAction/AnimationType/PedestrianAnimation"/>
            <xsl:copy-of select="./AnimationAction/AnimationType/AnimationFile"/>
            <xsl:copy-of select="./AnimationAction/AnimationType/UserDefinedAnimation"/>
        </xsl:element>
    </xsl:template>
	
	<!-- ComponentAnimation now is choice instead of sequence, thus the second element is removed to make it a valid OSC 1.3 scenario -->	
    <xsl:template name="ComponentAnimationFromAppearanceAction">
        <xsl:element name="ComponentAnimation">
            <xsl:choose>
                <xsl:when
                    test="./AnimationAction/AnimationType/ComponentAnimation/VehicleComponent and ./AnimationAction/AnimationType/ComponentAnimation/UserDefinedComponent">
                    <xsl:message terminate="no"> WARNING: ComponentAnimation cannot contain both
                        VehicleComponent and UserDefinedComponent since they exclude each other. The
                        second element is automatically removed. Please check the output manually to
                        make sure the resulting scenario is correct. </xsl:message>
                    <xsl:copy-of
                        select="./AnimationAction/AnimationType/ComponentAnimation/VehicleComponent"
                    />
                </xsl:when>
                <xsl:when
                    test="./AnimationAction/AnimationType/ComponentAnimation/VehicleComponent and not(./AnimationAction/AnimationType/ComponentAnimation/UserDefinedComponent)">
                    <xsl:copy-of
                        select="./AnimationAction/AnimationType/ComponentAnimation/VehicleComponent"
                    />
                </xsl:when>
                <xsl:when
                    test="./AnimationAction/AnimationType/ComponentAnimation/UserDefinedComponent and not(./AnimationAction/AnimationType/ComponentAnimation/VehicleComponent)">
                    <xsl:copy-of
                        select="./AnimationAction/AnimationType/ComponentAnimation/UserDefinedComponent"
                    />
                </xsl:when>
            </xsl:choose>
        </xsl:element>
    </xsl:template>

    <!-- default value for orientation was changed from absolute to relative, thus for old files value absolute is added if no value was defined -->
    <xsl:template match="//GeoPosition">
        <xsl:element name="GeoPosition">
            <xsl:copy-of select="./@altitude"/>
            <xsl:copy-of select="./@height"/>
            <xsl:copy-of select="./@latitude"/>
            <xsl:copy-of select="./@latitudeDeg"/>
            <xsl:copy-of select="./@longitude"/>
            <xsl:copy-of select="./@longitudeDeg"/>
            <xsl:choose>
                <xsl:when test="./Orientation">
                    <xsl:apply-templates/>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:element name="Orientation">
                        <xsl:attribute name="type">absolute</xsl:attribute>
                    </xsl:element>
                </xsl:otherwise>
            </xsl:choose>
        </xsl:element>
    </xsl:template>
    <xsl:template match="//LanePosition">
        <xsl:element name="LanePosition">
            <xsl:copy-of select="./@laneId"/>
            <xsl:copy-of select="./@offset"/>
            <xsl:copy-of select="./@roadId"/>
            <xsl:copy-of select="./@s"/>
            <xsl:choose>
                <xsl:when test="./Orientation">
                    <xsl:apply-templates/>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:element name="Orientation">
                        <xsl:attribute name="type">absolute</xsl:attribute>
                    </xsl:element>
                </xsl:otherwise>
            </xsl:choose>
        </xsl:element>
    </xsl:template>
    <xsl:template match="//RelativeLanePosition">
        <xsl:element name="RelativeLanePosition">
            <xsl:copy-of select="./@dLane"/>
            <xsl:copy-of select="./@ds"/>
            <xsl:copy-of select="./@dsLane"/>
            <xsl:copy-of select="./@entityRef"/>
            <xsl:copy-of select="./@offset"/>
            <xsl:choose>
                <xsl:when test="./Orientation">
                    <xsl:apply-templates/>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:element name="Orientation">
                        <xsl:attribute name="type">absolute</xsl:attribute>
                    </xsl:element>
                </xsl:otherwise>
            </xsl:choose>
        </xsl:element>
    </xsl:template>
    <xsl:template match="//RelativeObjectPosition">
        <xsl:element name="RelativeObjectPosition">
            <xsl:copy-of select="./@dx"/>
            <xsl:copy-of select="./@dy"/>
            <xsl:copy-of select="./@dz"/>
            <xsl:copy-of select="./@entityRef"/>
            <xsl:choose>
                <xsl:when test="./Orientation">
                    <xsl:apply-templates/>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:element name="Orientation">
                        <xsl:attribute name="type">absolute</xsl:attribute>
                    </xsl:element>
                </xsl:otherwise>
            </xsl:choose>
        </xsl:element>
    </xsl:template>
    <xsl:template match="//RelativeRoadPosition">
        <xsl:element name="RelativeRoadPosition">
            <xsl:copy-of select="./@ds"/>
            <xsl:copy-of select="./@dt"/>
            <xsl:copy-of select="./@entityRef"/>
            <xsl:choose>
                <xsl:when test="./Orientation">
                    <xsl:apply-templates/>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:element name="Orientation">
                        <xsl:attribute name="type">absolute</xsl:attribute>
                    </xsl:element>
                </xsl:otherwise>
            </xsl:choose>
        </xsl:element>
    </xsl:template>
    <xsl:template match="//RelativeWorldPosition">
        <xsl:element name="RelativeWorldPosition">
            <xsl:copy-of select="./@dx"/>
            <xsl:copy-of select="./@dy"/>
            <xsl:copy-of select="./@dz"/>
            <xsl:copy-of select="./@entityRef"/>
            <xsl:choose>
                <xsl:when test="./Orientation">
                    <xsl:apply-templates/>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:element name="Orientation">
                        <xsl:attribute name="type">absolute</xsl:attribute>
                    </xsl:element>
                </xsl:otherwise>
            </xsl:choose>
        </xsl:element>
    </xsl:template>
    <xsl:template match="//RoadPosition">
        <xsl:element name="RoadPosition">
            <xsl:copy-of select="./@roadId"/>
            <xsl:copy-of select="./@s"/>
            <xsl:copy-of select="./@t"/>
            <xsl:choose>
                <xsl:when test="./Orientation">
                    <xsl:apply-templates/>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:element name="Orientation">
                        <xsl:attribute name="type">absolute</xsl:attribute>
                    </xsl:element>
                </xsl:otherwise>
            </xsl:choose>
        </xsl:element>
    </xsl:template>
    <xsl:template match="//RoutePosition">
        <xsl:element name="RoutePosition">
            <xsl:copy-of select="./RouteRef"/>
            <xsl:choose>
                <xsl:when test="./Orientation">
                    <xsl:apply-templates/>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:element name="Orientation">
                        <xsl:attribute name="type">absolute</xsl:attribute>
                    </xsl:element>
                </xsl:otherwise>
            </xsl:choose>
            <xsl:copy-of select="./InRoutePosition"/>
        </xsl:element>
    </xsl:template>
    <xsl:template match="//TrajectoryPosition">
        <xsl:element name="TrajectoryPosition">
            <xsl:copy-of select="./@s"/>
            <xsl:copy-of select="./@t"/>
            <xsl:choose>
                <xsl:when test="./Orientation">
                    <xsl:apply-templates/>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:element name="Orientation">
                        <xsl:attribute name="type">absolute</xsl:attribute>
                    </xsl:element>
                </xsl:otherwise>
            </xsl:choose>
            <xsl:copy-of select="./TrajectoryRef"/>
        </xsl:element>
    </xsl:template>
    <xsl:template match="//Orientation">
        <xsl:element name="Orientation">
            <xsl:copy-of select="./@h"/>
            <xsl:copy-of select="./@p"/>
            <xsl:copy-of select="./@r"/>
            <xsl:choose>
                <xsl:when test="./@type">
                    <xsl:copy-of select="./@type"/>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:attribute name="type">absolute</xsl:attribute>
                </xsl:otherwise>
            </xsl:choose>
        </xsl:element>
    </xsl:template>

    <!-- Min occurs was increased from 0 to 1 of subelements for all following classes. If no subelement is present a warning is shown.  -->
    <xsl:template match="//Action">
        <xsl:copy>
            <xsl:apply-templates select="node() | @* | processing-instruction() | comment()"/>
        </xsl:copy>
        <xsl:if test="not(./GlobalAction) and not(./UserDefinedAction) and not(./PrivateAction)">
            <xsl:message terminate="no">"WARNING: Action must contain one of Action.GlobalAction,
                Action.UserDefinedAction, or Action.PrivateAction (XOR). No changes done. Please add
                one of the elements to make it a valid OSC 1.3 scenario."</xsl:message>
        </xsl:if>
    </xsl:template>
    <xsl:template match="//AssignControllerAction">
        <xsl:copy>
            <xsl:apply-templates select="node() | @* | processing-instruction() | comment()"/>
        </xsl:copy>
        <xsl:if test="not(./Controller) and not(./CatalogReference)">
            <xsl:message terminate="no">"WARNING: AssignControllerAction must contain one of
                AssignControllerAction.Controller or AssignControllerAction.CatalogReference (XOR).
                No changes done. Please add one of the elements to make it a valid OSC 1.3
                scenario."</xsl:message>
        </xsl:if>
    </xsl:template>
    <xsl:template match="//AssignRouteAction">
        <xsl:copy>
            <xsl:apply-templates select="node() | @* | processing-instruction() | comment()"/>
        </xsl:copy>
        <xsl:if test="not(./Route) and not(./CatalogReference)">
            <xsl:message terminate="no">"WARNING: AssignRouteAction must contain one of
                AssignRouteAction.Route or AssignRouteAction.CatalogReference (XOR). No changes
                done. Please add one of the elements to make it a valid OSC 1.3
                scenario."</xsl:message>
        </xsl:if>
    </xsl:template>
    <xsl:template match="//ByValueCondition">
        <xsl:copy>
            <xsl:apply-templates select="node() | @* | processing-instruction() | comment()"/>
        </xsl:copy>
        <xsl:if
            test="not(./ParameterCondition) and not(./TimeOfDayCondition) and not(./SimulationTimeCondition) and not(./StoryboardElementStateCondition) and not(./UserDefinedValueCondition) and not(./TrafficSignalCondition) and not(./TrafficSignalControllerCondition) and not(./VariableCondition)">
            <xsl:message terminate="no">"WARNING: ByValueCondition must contain one of
                ByValueCondition.ParameterCondition, ByValueCondition.TimeOfDayCondition,
                ByValueCondition.SimulationTimeCondition,
                ByValueCondition.StoryboardElementStateCondition,
                ByValueCondition.UserDefinedValueCondition, ByValueCondition.TrafficSignalCondition,
                ByValueCondition.TrafficSignalControllerCondition or
                ByValueCondition.VariableCondition (XOR). No changes done. Please add one of the
                elements to make it a valid OSC 1.3 scenario."</xsl:message>
        </xsl:if>
    </xsl:template>
    <xsl:template match="//CollisionCondition">
        <xsl:copy>
            <xsl:apply-templates select="node() | @* | processing-instruction() | comment()"/>
        </xsl:copy>
        <xsl:if test="not(./EntityRef) and not(./ByType)">
            <xsl:message terminate="no">"WARNING: CollisionCondition must contain one of
                CollisionCondition.EntityRef or CollisionCondition.ByType (XOR). No changes done.
                Please add one of the elements to make it a valid OSC 1.3 scenario."</xsl:message>
        </xsl:if>
    </xsl:template>
    <xsl:template match="//Condition">
        <xsl:copy>
            <xsl:apply-templates select="node() | @* | processing-instruction() | comment()"/>
        </xsl:copy>
        <xsl:if test="not(./ByEntityCondition) and not(./ByValueCondition)">
            <xsl:message terminate="no">"WARNING: Condition must contain one of
                Condition.ByEntityCondition or Condition.ByValueCondition (XOR). No changes done.
                Please add one of the elements to make it a valid OSC 1.3 scenario."</xsl:message>
        </xsl:if>
    </xsl:template>
    <xsl:template match="//ControllerDistributionEntry">
        <xsl:copy>
            <xsl:apply-templates select="node() | @* | processing-instruction() | comment()"/>
        </xsl:copy>
        <xsl:if test="not(./Controller) and not(./CatalogReference)">
            <xsl:message terminate="no">"WARNING: ControllerDistributionEntry must contain one of
                ControllerDistributionEntry.Controller or
                ControllerDistributionEntry.CatalogReference (XOR). No changes done. Please add one
                of the elements to make it a valid OSC 1.3 scenario."</xsl:message>
        </xsl:if>
    </xsl:template>
    <xsl:template match="//EntityAction">
        <xsl:copy>
            <xsl:apply-templates select="node() | @* | processing-instruction() | comment()"/>
        </xsl:copy>
        <xsl:if test="not(./AddEntityAction) and not(./DeleteEntityAction)">
            <xsl:message terminate="no">"WARNING: EntityAction must contain one of
                EntityAction.AddEntityAction or EntityAction.DeleteEntityAction (XOR). No changes
                done. Please add one of the elements to make it a valid OSC 1.3
                scenario."</xsl:message>
        </xsl:if>
    </xsl:template>
    <xsl:template match="//EntityCondition">
        <xsl:copy>
            <xsl:apply-templates select="node() | @* | processing-instruction() | comment()"/>
        </xsl:copy>
        <xsl:if
            test="not(./EndOfRoadCondition) and not(./CollisionCondition) and not(./OffroadCondition) and not(./TimeHeadwayCondition) and not(./TimeToCollisionCondition) and not(./AccelerationCondition) and not(./StandStillCondition) and not(./SpeedCondition) and not(./RelativeSpeedCondition) and not(./TraveledDistanceCondition) and not(./ReachPositionCondition) and not(./DistanceCondition) and not(./RelativeDistanceCondition) and not(./RelativeClearanceCondition)">
            <xsl:message terminate="no">"WARNING: EntityCondition must contain one of
                EntityCondition.EndOfRoadCondition, EntityCondition.CollisionCondition,
                EntityCondition.OffroadCondition, EntityCondition.TimeHeadwayCondition,
                EntityCondition.TimeToCollisionCondition, EntityCondition.AccelerationCondition,
                EntityCondition.StandStillCondition, EntityCondition.SpeedCondition,
                EntityCondition.RelativeSpeedCondition, EntityCondition.TraveledDistanceCondition,
                EntityCondition.ReachPositionCondition, EntityCondition.DistanceCondition,
                EntityCondition.RelativeDistanceCondition or
                EntityCondition.RelativeClearanceCondition (XOR). No changes done. Please add one of
                the elements to make it a valid OSC 1.3 scenario."</xsl:message>
        </xsl:if>
    </xsl:template>
    <xsl:template match="//EntityObject">
        <xsl:copy>
            <xsl:apply-templates select="node() | @* | processing-instruction() | comment()"/>
        </xsl:copy>
        <xsl:if
            test="not(./CatalogReference) and not(./Vehicle) and not(./Pedestrian) and not(./MiscObject) and not(./ExternalObjectReference)">
            <xsl:message terminate="no">"WARNING: EntityObject must contain one of
                EntityObject.CatalogReference, EntityObject.Vehicle, EntityObject.Pedestrian,
                EntityObject.MiscObject or EntityObject.ExternalObjectReference (XOR). No changes
                done. Please add one of the elements to make it a valid OSC 1.3
                scenario."</xsl:message>
        </xsl:if>
    </xsl:template>
    <xsl:template match="//EnvironmentAction">
        <xsl:copy>
            <xsl:apply-templates select="node() | @* | processing-instruction() | comment()"/>
        </xsl:copy>
        <xsl:if test="not(./Environment) and not(./CatalogReference)">
            <xsl:message terminate="no">"WARNING: EnvironmentAction must contain one of
                EnvironmentAction.Environment or EnvironmentAction.CatalogReference (XOR). No
                changes done. Please add one of the elements to make it a valid OSC 1.3
                scenario."</xsl:message>
        </xsl:if>
    </xsl:template>
    <xsl:template match="//FinalSpeed">
        <xsl:copy>
            <xsl:apply-templates select="node() | @* | processing-instruction() | comment()"/>
        </xsl:copy>
        <xsl:if test="not(./AbsoluteSpeed) and not(./RelativeSpeedToMaster)">
            <xsl:message terminate="no">"WARNING: FinalSpeed must contain one of
                FinalSpeed.AbsoluteSpeed or FinalSpeed.RelativeSpeedToMaster (XOR). No changes done.
                Please add one of the elements to make it a valid OSC 1.3 scenario."</xsl:message>
        </xsl:if>
    </xsl:template>
    <xsl:template match="//GlobalAction">
        <xsl:copy>
            <xsl:apply-templates select="node() | @* | processing-instruction() | comment()"/>
        </xsl:copy>
        <xsl:if
            test="not(./EnvironmentAction) and not(./EntityAction) and not(./ParameterAction) and not(./InfrastructureAction) and not(./TrafficAction) and not(./VariableAction)">
            <xsl:message terminate="no">"WARNING: GlobalAction must contain one of
                GlobalAction.EnvironmentAction, GlobalAction.ParameterAction,
                GlobalAction.InfrastructureAction, GlobalAction.TrafficAction or
                GlobalAction.VariableAction (XOR). No changes done. Please add one of the elements
                to make it a valid OSC 1.3 scenario."</xsl:message>
        </xsl:if>
    </xsl:template>
    <xsl:template match="//InRoutePosition">
        <xsl:copy>
            <xsl:apply-templates select="node() | @* | processing-instruction() | comment()"/>
        </xsl:copy>
        <xsl:if
            test="not(./FromCurrentEntity) and not(./FromRoadCoordinates) and not(./FromLaneCoordinates)">
            <xsl:message terminate="no">"WARNING: InRoutePosition must contain one of
                InRoutePosition.FromCurrentEntity, InRoutePosition.FromRoadCoordinates, or
                InRoutePosition.FromLaneCoordinates (XOR). No changes done. Please add one of the
                elements to make it a valid OSC 1.3 scenario."</xsl:message>
        </xsl:if>
    </xsl:template>
    <xsl:template match="//LaneChangeTarget">
        <xsl:copy>
            <xsl:apply-templates select="node() | @* | processing-instruction() | comment()"/>
        </xsl:copy>
        <xsl:if test="not(./RelativeTargetLane) and not(./AbsoluteTargetLane)">
            <xsl:message terminate="no">"WARNING: LaneChangeTarget must contain one of
                LaneChangeTarget.RelativeTargetLane or LaneChangeTarget.AbsoluteTargetLane (XOR). No
                changes done. Please add one of the elements to make it a valid OSC 1.3
                scenario."</xsl:message>
        </xsl:if>
    </xsl:template>
    <xsl:template match="//LaneOffsetTarget">
        <xsl:copy>
            <xsl:apply-templates select="node() | @* | processing-instruction() | comment()"/>
        </xsl:copy>
        <xsl:if test="not(./RelativeTargetLaneOffset) and not(./AbsoluteTargetLaneOffset)">
            <xsl:message terminate="no">"WARNING: LaneOffsetTarget must contain one of
                LaneOffsetTarget.RelativeTargetLaneOffset or
                LaneOffsetTarget.AbsoluteTargetLaneOffset (XOR). No changes done. Please add one of
                the elements to make it a valid OSC 1.3 scenario."</xsl:message>
        </xsl:if>
    </xsl:template>
    <xsl:template match="//LateralAction">
        <xsl:copy>
            <xsl:apply-templates select="node() | @* | processing-instruction() | comment()"/>
        </xsl:copy>
        <xsl:if
            test="not(./LaneChangeAction) and not(./LaneOffsetAction) and not(./LateralDistanceAction)">
            <xsl:message terminate="no">"WARNING: LateralAction must contain one of
                LateralAction.LaneChangeAction, LateralAction.LaneOffsetAction, or
                LateralAction.LateralDistanceAction (XOR). No changes done. Please add one of the
                elements to make it a valid OSC 1.3 scenario."</xsl:message>
        </xsl:if>
    </xsl:template>
    <xsl:template match="//LongitudinalAction">
        <xsl:copy>
            <xsl:apply-templates select="node() | @* | processing-instruction() | comment()"/>
        </xsl:copy>
        <xsl:if
            test="not(./SpeedAction) and not(./LongitudinalDistanceAction) and not(./SpeedProfileAction)">
            <xsl:message terminate="no">"WARNING: LongitudinalAction must contain one of
                LongitudinalAction.SpeedAction, LongitudinalAction.LongitudinalDistanceAction, or
                LongitudinalAction.SpeedProfileAction (XOR). No changes done. Please add one of the
                elements to make it a valid OSC 1.3 scenario."</xsl:message>
        </xsl:if>
    </xsl:template>
    <xsl:template match="//ModifyRule">
        <xsl:copy>
            <xsl:apply-templates select="node() | @* | processing-instruction() | comment()"/>
        </xsl:copy>
        <xsl:if test="not(./AddValue) and not(./MultiplyByValue)">
            <xsl:message terminate="no">"WARNING: ModifyRule must contain one of ModifyRule.AddValue
                or ModifyRule.MultiplyByValue (XOR). No changes done. Please add one of the elements
                to make it a valid OSC 1.3 scenario."</xsl:message>
        </xsl:if>
    </xsl:template>
    <xsl:template match="//ObjectController">
        <xsl:copy>
            <xsl:apply-templates select="node() | @* | processing-instruction() | comment()"/>
        </xsl:copy>
        <xsl:if test="not(./CatalogReference) and not(./Controller)">
            <xsl:message terminate="no">"WARNING: ObjectController must contain one of
                ObjectController.CatalogReference or ObjectController.Controller (XOR). No changes
                done. Please add one of the elements to make it a valid OSC 1.3
                scenario."</xsl:message>
        </xsl:if>
    </xsl:template>
    <xsl:template match="//ParameterAction">
        <xsl:copy>
            <xsl:apply-templates select="node() | @* | processing-instruction() | comment()"/>
        </xsl:copy>
        <xsl:if test="not(./ParameterSetAction) and not(./ParameterModifyAction)">
            <xsl:message terminate="no">"WARNING: ParameterAction must contain one of
                ParameterAction.ParameterSetAction or ParameterAction.ParameterModifyAction (XOR).
                No changes done. Please add one of the elements to make it a valid OSC 1.3
                scenario."</xsl:message>
        </xsl:if>
    </xsl:template>
    <xsl:template match="//Position">
        <xsl:copy>
            <xsl:apply-templates select="node() | @* | processing-instruction() | comment()"/>
        </xsl:copy>
        <xsl:if
            test="not(./WorldPosition) and not(./RelativeWorldPosition) and not(./RelativeObjectPosition) and not(./RoadPosition) and not(./RelativeRoadPosition) and not(./LanePosition) and not(./RelativeLanePosition) and not(./RoutePosition) and not(./GeoPosition) and not(./TrajectoryPosition)">
            <xsl:message terminate="no">"WARNING: Position must contain one of
                Position.WorldPosition, Position.RelativeWorldPosition,
                Position.RelativeObjectPosition, Position.RoadPosition,
                Position.RelativeRoadPosition, Position.LanePosition, Position.RelativeLanePosition,
                Position.RoutePosition, Position.GeoPosition or Position.TrajectoryPosition (XOR).
                No changes done. Please add one of the elements to make it a valid OSC 1.3
                scenario."</xsl:message>
        </xsl:if>
    </xsl:template>
    <xsl:template match="//PrivateAction">
        <xsl:copy>
            <xsl:apply-templates select="node() | @* | processing-instruction() | comment()"/>
        </xsl:copy>
        <xsl:if
            test="not(./LongitudinalAction) and not(./LateralAction) and not(./VisibilityAction) and not(./SynchronizeAction) and not(./ActivateControllerAction) and not(./ControllerAction) and not(./TeleportAction) and not(./RoutingAction) and not(./AppearanceAction)">
            <xsl:message terminate="no">"WARNING: PrivateAction must contain one of
                PrivateAction.LongitudinalA ction, PrivateAction.LateralAction,
                PrivateAction.VisibilityAction, PrivateAction.SynchronizeAction,
                PrivateAction.ActivateControllerAction, PrivateAction.ControllerAction,
                PrivateAction.TeleportAction, PrivateAction.RoutingAction or
                PrivateAction.AppearanceAction (XOR). No changes done. Please add one of the
                elements to make it a valid OSC 1.3 scenario."</xsl:message>
        </xsl:if>
    </xsl:template>
    <xsl:template match="//RouteRef">
        <xsl:copy>
            <xsl:apply-templates select="node() | @* | processing-instruction() | comment()"/>
        </xsl:copy>
        <xsl:if test="not(./Route) and not(./CatalogReference)">
            <xsl:message terminate="no">"WARNING: RouteRef must contain one of RouteRef.Route or
                RouteRef.CatalogReference (XOR). No changes done. Please add one of the elements to
                make it a valid OSC 1.3 scenario."</xsl:message>
        </xsl:if>
    </xsl:template>
    <xsl:template match="//RoutingAction">
        <xsl:copy>
            <xsl:apply-templates select="node() | @* | processing-instruction() | comment()"/>
        </xsl:copy>
        <xsl:if
            test="not(./AssignRouteAction) and not(./FollowTrajectoryAction) and not(./AcquirePositionAction)">
            <xsl:message terminate="no">"WARNING: RoutingAction must contain one of
                RoutingAction.AssignRouteAction, RoutingAction.FollowTrajectoryAction, or
                RoutingAction.AcquirePositionAction (XOR). No changes done. Please add one of the
                elements to make it a valid OSC 1.3 scenario."</xsl:message>
        </xsl:if>
    </xsl:template>
    <xsl:template match="//SelectedEntities">
        <xsl:copy>
            <xsl:apply-templates select="node() | @* | processing-instruction() | comment()"/>
        </xsl:copy>
        <xsl:if test="not(./EntityRef) and not(./ByType)">
            <xsl:message terminate="no">"WARNING: SelectedEntities must contain one of
                SelectedEntities.EntityRef or SelectedEntities.ByType (XOR). No changes done. Please
                add one of the elements to make it a valid OSC 1.3 scenario."</xsl:message>
        </xsl:if>
    </xsl:template>
    <xsl:template match="//Shape">
        <xsl:copy>
            <xsl:apply-templates select="node() | @* | processing-instruction() | comment()"/>
        </xsl:copy>
        <xsl:if test="not(./Polyline) and not(./Clothoid) and not(./Nurbs)">
            <xsl:message terminate="no">"WARNING: Shape must contain one of Shape.Polyline,
                Shape.Clothoid, or Shape.Nurbs (XOR). No changes done. Please add one of the
                elements to make it a valid OSC 1.3 scenario."</xsl:message>
        </xsl:if>
    </xsl:template>
    <xsl:template match="//SpeedActionTarget">
        <xsl:copy>
            <xsl:apply-templates select="node() | @* | processing-instruction() | comment()"/>
        </xsl:copy>
        <xsl:if test="not(./RelativeTargetSpeed) and not(./AbsoluteTargetSpeed)">
            <xsl:message terminate="no">"WARNING: SpeedActionTarget must contain one of
                SpeedActionTarget.RelativeTargetSpeed or SpeedActionTarget.AbsoluteTargetSpeed
                (XOR). No changes done. Please add one of the elements to make it a valid OSC 1.3
                scenario."</xsl:message>
        </xsl:if>
    </xsl:template>
    <xsl:template match="//TimeReference">
        <xsl:copy>
            <xsl:apply-templates select="node() | @* | processing-instruction() | comment()"/>
        </xsl:copy>
        <xsl:if test="not(./None) and not(./Timing)">
            <xsl:message terminate="no">"WARNING: TimeReference must contain one of
                TimeReference.None or TimeReference.Timing (XOR). No changes done. Please add one of
                the elements to make it a valid OSC 1.3 scenario."</xsl:message>
        </xsl:if>
    </xsl:template>
    <xsl:template match="//TimeToCollisionConditionTarget">
        <xsl:copy>
            <xsl:apply-templates select="node() | @* | processing-instruction() | comment()"/>
        </xsl:copy>
        <xsl:if test="not(./Position) and not(./EntityRef)">
            <xsl:message terminate="no">"WARNING: TimeToCollisionConditionTarget must contain one of
                TimeToCollisionConditionTarget.Position or TimeToCollisionConditionTarget.EntityRef
                (XOR). No changes done. Please add one of the elements to make it a valid OSC 1.3
                scenario."</xsl:message>
        </xsl:if>
    </xsl:template>
    <xsl:template match="//TrafficAction">
        <xsl:copy>
            <xsl:apply-templates select="node() | @* | processing-instruction() | comment()"/>
        </xsl:copy>
        <xsl:if
            test="not(./TrafficSourceAction) and not(./TrafficSinkAction) and not(./TrafficSwarmAction) and not(./TrafficStopAction)">
            <xsl:message terminate="no">"WARNING: TrafficAction must contain one of
                TrafficAction.TrafficSourceAction, TrafficAction.TrafficSinkAction,
                TrafficAction.TrafficSwarmAction or TrafficAction.TrafficStopAction (XOR). No
                changes done. Please add one of the elements to make it a valid OSC 1.3
                scenario."</xsl:message>
        </xsl:if>
    </xsl:template>
    <xsl:template match="//TrafficSignalAction">
        <xsl:copy>
            <xsl:apply-templates select="node() | @* | processing-instruction() | comment()"/>
        </xsl:copy>
        <xsl:if test="not(./TrafficSignalControllerAction) and not(./TrafficSignalStateAction)">
            <xsl:message terminate="no">"WARNING: TrafficSignalAction must contain one of
                TrafficSignalAction.TrafficSignalControllerAction or
                TrafficSignalAction.TrafficSignalStateAction (XOR). No changes done. Please add one
                of the elements to make it a valid OSC 1.3 scenario."</xsl:message>
        </xsl:if>
    </xsl:template>
    <xsl:template match="//VariableAction">
        <xsl:copy>
            <xsl:apply-templates select="node() | @* | processing-instruction() | comment()"/>
        </xsl:copy>
        <xsl:if test="not(./SetAction) and not(./ModifyAction)">
            <xsl:message terminate="no">"WARNING: VariableAction must contain one of
                VariableAction.SetAction or VariableAction.ModifyAction (XOR). No changes done.
                Please add one of the elements to make it a valid OSC 1.3 scenario."</xsl:message>
        </xsl:if>
    </xsl:template>
    <xsl:template match="//VariableModifyRule">
        <xsl:copy>
            <xsl:apply-templates select="node() | @* | processing-instruction() | comment()"/>
        </xsl:copy>
        <xsl:if test="not(./AddValue) and not(./MultiplyByValue)">
            <xsl:message terminate="no">"WARNING: VariableModifyRule must contain one of
                VariableModifyRule.AddValue or VariableModifyRule.MultiplyByValue (XOR). No changes
                done. Please add one of the elements to make it a valid OSC 1.3
                scenario."</xsl:message>
        </xsl:if>
    </xsl:template>
     
    <!-- Cardinality of name in element Catalog is increased to 1..1. -->
    <xsl:template match="//Catalog">
        <xsl:copy>
            <xsl:apply-templates select="node() | @* | processing-instruction() | comment()"/>
        </xsl:copy>
        <xsl:if test="not(./@name)">
            <xsl:message terminate="no">"WARNING: Catalog must contain a name attribute. Please add a name to make it a valid OSC 1.3 scenario."</xsl:message>
        </xsl:if>
    </xsl:template>
    
    <!-- <xsd:choice> instead of <xsd:all> for ControllerAction -->
    <xsl:template match="//ControllerAction">
        <xsl:choose>
        <xsl:when test="not(./AssignControllerAction) and not(./OverrideControllerValueAction) and not(./ActivateControllerAction)">
            <xsl:message terminate="no">"WARNING: ControllerAction must contain one of ControllerAction.AssignControllerAction, ControllerAction.ActivateControllerAction or
                ControllerAction.OverrideControllerValueAction (XOR). No changes done. Please add one of the elements to make it a valid OSC 1.3 scenario."</xsl:message>
        </xsl:when>
            <xsl:when test="(./AssignControllerAction and (./OverrideControllerValueAction or ./ActivateControllerAction))">
            <xsl:message terminate="no">"WARNING: ControllerAction must contain exactly one of ControllerAction.AssignControllerAction, ControllerAction.ActivateControllerAction or
                ControllerAction.OverrideControllerValueAction (XOR). ControllerAction.AssignControllerAction was selected and all other elements were removed. Please review and adapt this change if necessary."</xsl:message>
            <xsl:copy-of select="./AssignControllerAction"/>    
        </xsl:when>
            <xsl:when test="(not(./AssignControllerAction) and ./OverrideControllerValueAction and ./ActivateControllerAction)">
            <xsl:message terminate="no">"WARNING: ControllerAction must contain exactly one of ControllerAction.AssignControllerAction, ControllerAction.ActivateControllerAction or
                ControllerAction.OverrideControllerValueAction (XOR). ControllerAction.OverrideControllerValueAction was selected and all other elements were removed. Please review and adapt this change if necessary."</xsl:message>
            <xsl:copy-of select="./OverrideControllerValueAction"/>   
        </xsl:when>
        <xsl:otherwise>
            <xsl:copy>
                <xsl:apply-templates select="node() | @* | processing-instruction() | comment()"/>
            </xsl:copy>
        </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    
    <!-- Default behaviour of routing action was set. If no element was specified a warning message is shown. -->
    <xsl:template match="//Pedestrian">
        <xsl:copy>
            <xsl:apply-templates select="node() | @* | processing-instruction() | comment()"/>
        </xsl:copy>
        <xsl:if test="./Init">
            <xsl:if test="not(./Init/RoutingAction)">
                <xsl:message terminate="no">"WARNING: No RoutingAction specified for the entity. If random routing behavior at junctions is desired, a RandomRouteAction has to be used explicitly. If the entity shall go straight, no routing action needs to be defined."</xsl:message>
            </xsl:if>
        </xsl:if>
    </xsl:template>
    <xsl:template match="//Vehicle">
        <xsl:copy>
            <xsl:apply-templates select="node() | @* | processing-instruction() | comment()"/>
        </xsl:copy>
        <xsl:if test="./Init">
            <xsl:if test="not(./Init/RoutingAction)">
                <xsl:message terminate="no">"WARNING: No RoutingAction specified for the entity. If random routing behavior at junctions is desired, a RandomRouteAction has to be used explicitly. If the entity shall go straight, no routing action needs to be defined."</xsl:message>
            </xsl:if>
        </xsl:if>
    </xsl:template>
	
	<!-- Renamed attribute trafficeSignalGroupState of Phase (typo) to trafficSignalGroupState -->
	<xsl:template match="TrafficeSignalGroupState">
		<TrafficSignalGroupState>
		    <xsl:apply-templates select="node() | @* | processing-instruction() | comment()"/>
		</TrafficSignalGroupState>
	</xsl:template>
</xsl:stylesheet>
